import numpy as np
import scipy.ndimage
from matplotlib import pyplot as plt
import matplotlib
from matplotlib.patches import Polygon
from matplotlib.collections import PatchCollection
import matplotlib.gridspec as gridspec


######################################################################################################################################################
#   Code for producing Figure 7 in the main text.
#   The following data is used in this figure:
#   -- theoryRunLengthContour_const.txt, percent change the run length under 1 pN load as the load direction (parameterized by \theta_F and \phi_F)
#                                               is changed, predicted by the constrained diffusion theory with \mu_c = 5 k_B T. The final column in this
#                                               data file are the percent difference between the run length at a given angle and that under backward
#                                               load with \theta_F = 0.
#
######################################################################################################################################################

axisLabelSize = 24
lw = 2
msize = 7
legendTxt = 14
mkWidth = 2
handle = 0.6
tickLen=6
tickLabel=16

params = {'backend': 'ps'}

plt.rcParams.update(params)

fig = plt.figure(figsize=(10, 8))


theta, phi, rLength = np.transpose(np.loadtxt('theory_run_length_off_axis/theoryRunLengthContour_const.txt'))

numtheta = np.count_nonzero(theta==theta[1])
numphi = np.count_nonzero(phi==phi[1])
theta = theta[::numtheta]
phi = phi[:int(len(phi)/numphi)]
rLength = np.transpose(np.reshape(rLength,[numphi, numtheta]))

rLength = scipy.ndimage.zoom(rLength, 3)
theta = scipy.ndimage.zoom(theta,3)
phi = scipy.ndimage.zoom(phi,3)


levels = np.concatenate([np.arange(-15,1,5),np.arange(10,95,10)])
cont = plt.contourf(theta, phi, rLength, levels, cmap=plt.cm.YlOrBr)
plt.contour(theta, phi, rLength, levels, colors='k', linestyles='solid')

plt.xlabel(r'$\theta_F$', size=axisLabelSize)
plt.ylabel(r'$\phi_F$', size=axisLabelSize)
plt.tick_params('both',length=tickLen,labelsize=tickLabel)

cbar = plt.colorbar(cont, label=r'Percent Change in Run length')

cbar.ax.tick_params(labelsize=18)
cbar.ax.yaxis.label.set_size(20)

plt.savefig('run_length_off_axis.pdf',bbox_inches='tight')

plt.show()